/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vconevnt;

import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Calendar;
import java.util.Date;

public class ViewConsoleEventsBean
extends PanelBean
implements DataBean {
    private static final String TRACE_MASKT = "HVCEDBNT";
    private static final String TRACE_MASKF = "HVCEDBNF";
    private static final String TRACE_MASKD = "HVCEDBND";
    private String[][] m_transdata;
    private String[][] m_subtransdata;
    private boolean m_isReversed = false;
    private String[] m_sDateCol;
    private ItemDescriptor[] m_idDateCol;
    private String[] m_sTimeCol;
    private ItemDescriptor[] m_idTimeCol;
    private String[] m_sEventCol;
    private ItemDescriptor[] m_idEventCol;
    private ItemDescriptor[] m_idViewConsoleEventsTable;
    private ColumnDescriptor[] m_cdViewConsoleEventsTableStructure;
    private int[] m_iViewConsoleEventsTableSelection;

    public ColumnDescriptor[] getViewConsoleEventsTableRowStructure() {
        return this.m_cdViewConsoleEventsTableStructure;
    }

    public int getViewConsoleEventsTableRowStatus() {
        return 3;
    }

    public int getViewConsoleEventsTableRowCount() {
        Trace.trace(TRACE_MASKT, ">> getViewConsoleEventsTableRowCount: length = " + this.m_transdata.length);
        return this.m_transdata.length;
    }

    public ItemDescriptor[] getViewConsoleEventsTableRowAt(int index) {
        return this.m_idViewConsoleEventsTable;
    }

    public void setViewConsoleEventsTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idViewConsoleEventsTable = items;
    }

    public int[] getViewConsoleEventsTableSelection() {
        return this.m_iViewConsoleEventsTableSelection;
    }

    public void setViewConsoleEventsTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iViewConsoleEventsTableSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public ItemDescriptor[] getDateColList() {
        return this.m_idDateCol;
    }

    public void setDateColList(ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idDateCol = items;
    }

    public String[] getDateColSelection() {
        return this.m_sDateCol;
    }

    public void setDateColSelection(String[] select) throws IllegalUserDataException {
        this.m_sDateCol = select;
    }

    public ItemDescriptor[] getTimeColList() {
        return this.m_idTimeCol;
    }

    public void setTimeColList(ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idTimeCol = items;
    }

    public String[] getTimeColSelection() {
        return this.m_sTimeCol;
    }

    public void setTimeColSelection(String[] select) throws IllegalUserDataException {
        this.m_sTimeCol = select;
    }

    public ItemDescriptor[] getEventColList() {
        return this.m_idEventCol;
    }

    public void setEventColList(ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idEventCol = items;
    }

    public String[] getEventColSelection() {
        return this.m_sEventCol;
    }

    public void setEventColSelection(String[] select) throws IllegalUserDataException {
        this.m_sEventCol = select;
    }

    public void load() {
        this.m_sDateCol = new String[0];
        this.m_idDateCol = new ItemDescriptor[0];
        this.m_sTimeCol = new String[0];
        this.m_idTimeCol = new ItemDescriptor[0];
        this.m_sEventCol = new String[0];
        this.m_idEventCol = new ItemDescriptor[0];
        this.m_idViewConsoleEventsTable = new ItemDescriptor[0];
        this.m_cdViewConsoleEventsTableStructure = new ColumnDescriptor[0];
        this.m_iViewConsoleEventsTableSelection = new int[0];
    }

    public void populateTable(String[][] taskData, boolean isReverse) {
        Trace.trace(TRACE_MASKT, ">> populateTable: taskData.length = " + taskData.length);
        this.m_idDateCol = new ItemDescriptor[taskData.length];
        this.m_idTimeCol = new ItemDescriptor[taskData.length];
        this.m_idEventCol = new ItemDescriptor[taskData.length];
        if (isReverse) {
            for (int i = 0; i < taskData.length; ++i) {
                this.m_idDateCol[taskData.length - 1 - i] = new ItemDescriptor("date" + new Integer(i).toString(), taskData[i][0]);
                this.m_idTimeCol[taskData.length - 1 - i] = new ItemDescriptor("time" + new Integer(i).toString(), taskData[i][1]);
                this.m_idEventCol[taskData.length - 1 - i] = new ItemDescriptor("event" + new Integer(i).toString(), taskData[i][2]);
            }
        } else {
            for (int i = 0; i < taskData.length; ++i) {
                this.m_idDateCol[i] = new ItemDescriptor("date" + new Integer(i).toString(), taskData[i][0]);
                this.m_idTimeCol[i] = new ItemDescriptor("time" + new Integer(i).toString(), taskData[i][1]);
                this.m_idEventCol[i] = new ItemDescriptor("event" + new Integer(i).toString(), taskData[i][2]);
            }
        }
        this.userTaskManager.refreshElement(this.getMountPrefix() + "ViewConsoleEventsTable");
    }

    public void setItemDescriptorInfo(String[][] taskData) {
        this.m_transdata = taskData;
        this.m_subtransdata = taskData;
    }

    public int findLimit(String[][] taskDataIn, Date lowerLimit) {
        int retval = 0;
        int i = 0;
        int j = 0;
        long hundredths = 0L;
        long testLimit = lowerLimit.getTime();
        testLimit -= testLimit % 1000L;
        i = 0;
        j = taskDataIn.length;
        while (i < taskDataIn.length) {
            long testData = new Long(taskDataIn[i][3]);
            testData -= testData % 1000L;
            Trace.trace(TRACE_MASKF, "taskDataIn[" + i + "][3] = " + taskDataIn[i][3]);
            Trace.trace(TRACE_MASKF, "testData = " + testData + ",hundredths= " + hundredths + ",testLimit = " + testLimit + ", i=" + i + ", j=" + j);
            if (testLimit >= testData) {
                retval = j;
                break;
            }
            ++i;
            --j;
        }
        Trace.trace(TRACE_MASKF, "return values:  i = " + i + "; j = " + j);
        return retval;
    }

    public int findUpperLimit(String[][] taskDataIn, Date upperLimit) {
        int retval = taskDataIn.length;
        for (int i = taskDataIn.length - 1; i >= 0; --i) {
            if (new Long(taskDataIn[i][3]) <= upperLimit.getTime()) continue;
            retval = i;
            i = -1;
        }
        return retval;
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        Trace.trace(TRACE_MASKT, ">> parentalAction: ");
    }

    public boolean isOutOfBounds(String[][] taskDataIn, Date lowerLimit) {
        boolean retval = false;
        long testData = new Long(taskDataIn[taskDataIn.length - 1][3]);
        testData -= testData % 1000L;
        long testLimit = lowerLimit.getTime();
        if ((testLimit -= testLimit % 1000L) < testData) {
            retval = true;
        }
        return retval;
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, ">> update: newData = " + newData);
        Calendar[] dateArray = (Calendar[])newData;
        Calendar newendDate = dateArray[0];
        Calendar newendTime = dateArray[1];
        Calendar testdate = null;
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            testdate = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        }
        catch (NullContextException e) {
            testdate = Calendar.getInstance();
        }
        if (newendDate != null) {
            testdate.set(1, newendDate.get(1));
            testdate.set(2, newendDate.get(2));
            testdate.set(5, newendDate.get(5));
            testdate.set(11, newendTime.get(11));
            testdate.set(12, newendTime.get(12));
            testdate.set(13, newendTime.get(13));
            testdate.getTime();
            Trace.trace(TRACE_MASKT, "update: testdate.getTime() = " + testdate.getTime());
            int upperLimit = this.findLimit(this.m_transdata, testdate.getTime());
            Trace.trace(TRACE_MASKF, "update: upperlimit = " + upperLimit);
            Trace.trace(TRACE_MASKF, "update: m_transdata.length = " + this.m_transdata.length);
            if (upperLimit == 0) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("menuevent", "popnologs");
                this.postTaskletRequest(request);
            } else {
                this.m_subtransdata = new String[upperLimit][4];
                Trace.trace(TRACE_MASKT, "update: m_subtransdata.length = " + this.m_subtransdata.length);
                for (int i = 0; i < upperLimit; ++i) {
                    this.m_subtransdata[i] = this.m_transdata[this.m_transdata.length - (upperLimit - i)];
                }
                this.populateTable(this.m_subtransdata, this.m_isReversed);
            }
        }
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, ">> panelAction: ");
        String elementName = event.getActionCommand();
        Trace.trace(TRACE_MASKT, ">>>CONSOLEEVENTSBEAN>>> panelAction: elementName is " + elementName);
        if (elementName.equals("ViewMenu.InReverseOrderOfOccurrenceItem")) {
            this.m_isReversed = false;
            this.populateTable(this.m_subtransdata, false);
        } else if (elementName.equals("ViewMenu.InOrderOfOccurrenceItem")) {
            this.m_isReversed = true;
            this.populateTable(this.m_subtransdata, true);
        } else if (elementName.equals("ViewMenu.UsingDifferentTimeRangeItem")) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", event);
            if (this.m_subtransdata.length == 0) {
                request.setData("startendData", null);
            } else {
                request.setData("startendData", new String[]{this.m_subtransdata[this.m_subtransdata.length - 1][0], this.m_subtransdata[this.m_subtransdata.length - 1][1], this.m_subtransdata[this.m_subtransdata.length - 1][3], this.m_subtransdata[0][0], this.m_subtransdata[0][1], this.m_subtransdata[0][3]});
                request.setData("startendrefreshData", new String[]{this.m_transdata[this.m_transdata.length - 1][0], this.m_transdata[this.m_transdata.length - 1][1], this.m_transdata[this.m_transdata.length - 1][3], this.m_transdata[0][0], this.m_transdata[0][1], this.m_transdata[0][3]});
            }
            this.postTaskletRequest(request);
        } else if (elementName.equals("ViewMenu.ExitItem") || elementName.equals("CANCEL")) {
            this.dispose();
        } else if (elementName.equals("OKButton")) {
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<< panelAction: ");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, ">> prepare: ");
        if (this.m_transdata != null) {
            this.populateTable(this.m_transdata, false);
        } else {
            this.m_sDateCol = new String[0];
            this.m_idDateCol = new ItemDescriptor[0];
            this.m_sTimeCol = new String[0];
            this.m_idTimeCol = new ItemDescriptor[0];
            this.m_sEventCol = new String[0];
            this.m_idEventCol = new ItemDescriptor[0];
            this.m_idViewConsoleEventsTable = new ItemDescriptor[0];
            this.m_cdViewConsoleEventsTableStructure = new ColumnDescriptor[0];
            this.m_iViewConsoleEventsTableSelection = new int[0];
        }
        Trace.trace(TRACE_MASKT, "<< prepare: ");
    }
}

